\version "2.24.0"
\language "deutsch"

\paper {
  markup-system-spacing = #'((basic-distance . 19))
  system-system-spacing = #'((basic-distance . 23))
  left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  top-margin = 5\mm
  %ragged-last-bottom=##f
  %system-count = #3
}

% diacritice: ă â î ş ţ Ţ Ş Ă Î

\header {
  title = "Treceți batalioane"
  subtitle = " "
  %subsubtitle = " "
  composer = \markup \center-column { "Constantin Mandicevschi" \small 
  "(1859–1933)" }
  %poet = "Karl Barth"
  %arranger = "arm. după I. D. Chirescu"
  %meter = "Largo"
  tagline=""
}

global = {
  \key d \minor
  %\autoBeamOff
  %\cadenzaOn
  %\time 2/4
  \partial 8
  \set Staff.midiInstrument = "clarinet"
}

womenWordsOne = \lyricmode {
 \set stanza = "1."
 Tre -- ceți ba -- ta -- lioa -- ne ro -- mâ -- ne Car -- pa -- ții,
 la ar -- me cu frun -- ze și flori.
 V-aș -- teap -- tă iz -- bân -- da, v-aș -- teap -- tă și fra -- ții
 cu i -- ni -- ma la tre -- că -- tori, __
 v-aș -- teap -- tă iz -- bân -- da, v-aș -- teap -- tă și fra -- ții
 cu i -- ni -- ma la trei cu -- lori.
 Cu i -- ni -- ma la trei cu -- lori.
}

womenWordsTwo = \lyricmode {
 \set stanza = "2."
 Ar -- dea -- lul, Ar -- dea -- lul, Ar -- dea -- lul ne chea -- mă,
 nă -- dej -- dea e nu -- mai la noi!
 Să -- ru -- tă-ţi, co -- pi -- le, pă -- rin -- ţii şi fra -- ţii
 ș-a -- poi să mer -- gem la răz -- boi, __
 să -- ru -- tă-ţi, co -- pi -- le, pă -- rin -- ţii şi fra -- ţii
 ș-a -- poi să mer -- gem la răz -- boi.
} 

womenWordsThree = \lyricmode {
 \set stanza = "3."
 'Na -- in -- te! 'Na -- in -- te spre Ma -- rea U -- ni -- re,
 ho -- ta -- rul ne -- drept să-l zdro -- bim!
 Să tre -- cem Car -- pa -- ții, ne trebu -- ie Ar -- dea -- lul,
 de-o fi să ne-n -- gro -- păm de vii, __
 să tre -- cem Car -- pa -- ții, ne trebu -- ie Ar -- dea -- lul,
 de-o fi să ne-n -- gro -- păm de vii!
} 

menWords = \lyricmode {
  
}
  
sopMusic = \relative c' {
 a8 d4 d8 e f4 f8 g a4 a8 b a4 d,8
 d8 g4 g8 b d4 c8 b a2. b8\rest
 a8 g4 g8 a b4 a8 g f4 f8 g a4 g8 f 
 e8 e e e a4 a d,8( e f g a4) b8\rest
 a8 g4 g8 a b4 a8 g f4 f8 g a4 g8 f 
 e8 e e e a4 a d,2. b'4\rest \bar":|." \break
 \partial 8 f8 ^\markup "Fine"
 e8 e e e a4 a d2.^\fermata 
 \bar"|."  
}

altMusic = \relative c' {
 a8 d4 d8 e f4 f8 e f4 f8 g f4 d8
 d e4 e8 g b4 a8 g f2. b8\rest
 f8 e4 e8 f g4 f8 e f4 f8 e f4
 e8 f e8 e e e f4 f d( e f) b8\rest
 f8 e4 e8 f g4 f8 e f4 f8 e f4
 e8 f e8 e e e f4 f d2. b'4\rest
 f8 e e e e f4 f d2.
 }

bassMusic = \relative c {
 a8 d4 d8 a d4 d8 c d4 d8 d d4 d8
 d c4 c8 c f4 f8 f f2. r8 r
 r1 r r r2. r8
 f8 c4 c8 c c4 c8 c f4 f8 f f4 f8 f
 c8 c c c d4 d d2. r4
 f8 c c c c d4 d d2.
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
      \new Voice { \global \voiceOne \sopMusic }
      \addlyrics { \womenWordsOne }
      \addlyrics { \womenWordsTwo }
      \addlyrics { \womenWordsThree }
      \new Voice { \global \voiceTwo \altMusic }      
    >>
    \new Staff <<
      \clef bass
      %\new Voice { \global \altMusic }      
      \new Voice { \global \bassMusic }
      %\addlyrics { \menWords }
    >>
    >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
  \tempo 4 = 78
  \context { \Voice \remove "Dynamic_performer" }
}

\score {
  %\unfoldRepeats
  \myScore
  \midi { \midiOutput }
}

\score {
  %\unfoldRepeats
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  %\unfoldRepeats
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  %\unfoldRepeats
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}